<?php

/**
 * This is the model class for table "SzkolenieOdpowiedziFirmy".
 *
 * The followings are the available columns in table 'SzkolenieOdpowiedziFirmy':
 * @property double $idSzkolenieFirmy
 * @property double $idOdpowiedzi
 * @property double $idPytania
 * @property string $wartosc
 */

class SzkolenieOdpowiedziFirmy extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SzkolenieOdpowiedziFirmy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'SzkolenieOdpowiedziFirmy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idSzkolenieFirmy, idOdpowiedzi, idPytania', 'numerical'),
			array('wartosc', 'length', 'max' => 512),
			array('idSzkolenieFirmy, idOdpowiedzi, idPytania, wartosc', 'safe', 'on'=>'search'),
		);
	}

	public function primaryKey()
	{
		return array('idSzkolenieFirmy', 'idPytania');
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'szkolenieFirmy' => array(self::BELONGS_TO, 'SzkolenieFirmy', 'idSzkolenieFirmy'),
			'odpowiedz'=>array(self::BELONGS_TO, 'SzkolenieOdpowiedziEgzamin', 'idOdpowiedzi'),
			'pytanie'=>array(self::BELONGS_TO, 'SzkoleniePytaniaEgzamin', 'idPytania'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idSzkolenieFirmy'=>Yii::t('SzkolenieOdpowiedziFirmy', 'idSzkolenieFirmy'),
			'idOdpowiedzi'=>Yii::t('SzkolenieOdpowiedziFirmy', 'idOdpowiedzi'),
			'idPytania'=>Yii::t('SzkolenieOdpowiedziFirmy', 'idPytania'),
			'wartosc'=>Yii::t('SzkolenieOdpowiedziFirmy', 'wartosc'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('idSzkolenieFirmy', $this->idSzkolenieFirmy);
		$criteria->compare('idOdpowiedzi', $this->idOdpowiedzi);
		$criteria->compare('idPytania', $this->idPytania);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
